<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
    $auth_branch = 3;
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.all_missions')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <!--begin::Card-->
    <div class="card">
        <!--begin::Card header-->
        <div class="card-header border-0 pt-6">
            <!--begin::Card title-->
            <div class="card-title">

                <!--begin::Search-->
                
                <?php echo $__env->make('adminLte.components.modules.datatable.search', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!--end::Search-->

            </div>
            <!--begin::Card title-->

            <!--begin::Card toolbar-->
            <div class="card-toolbar">
                <!--begin::Toolbar-->
                <div class="d-flex flex-wrap align-items-center" id="<?php echo e($table_id); ?>_custom_filter">
                    
                    <?php echo $__env->make('adminLte.components.modules.datatable.datatable_length', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    
                    <?php echo $__env->make('adminLte.components.modules.datatable.reload', ['table_id' => $table_id], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <!--begin::Filter-->
                    <?php if (isset($component)) { $__componentOriginal6166a680511730b9b409b675564b2279cb9dec75 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\TableFilter::class, []); ?>
<?php $component->withName('table-filter'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['table_id' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($table_id),'filters' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($filters)]); ?>
                        
                            <!-- ================== begin Role filter =============================== -->
                            <?php echo $__env->make('cargo::adminLte.pages.missions.table.filters.type', ['table_id' => $table_id, 'filters' => $filters], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('cargo::adminLte.pages.missions.table.filters.status', ['table_id' => $table_id, 'filters' => $filters], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php echo $__env->make('cargo::adminLte.pages.table.filters.driver', ['table_id' => $table_id, 'filters' => $filters], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <!-- ================== end Role filter =============================== -->
                        
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6166a680511730b9b409b675564b2279cb9dec75)): ?>
<?php $component = $__componentOriginal6166a680511730b9b409b675564b2279cb9dec75; ?>
<?php unset($__componentOriginal6166a680511730b9b409b675564b2279cb9dec75); ?>
<?php endif; ?>
                    <!--end::Filter-->
                    <!-- ================== begin export buttons =============================== -->
                    <?php echo $__env->make('adminLte.components.modules.datatable.export', ['table_id' => $table_id, 'btn_exports' => $btn_exports], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- ================== end export buttons =============================== -->
                </div>
                <!--end::Toolbar-->

                <?php if(count($actions) > 0): ?>

                    <!--begin::More actions -->
                    <?php $__env->startSection('more-actions'); ?>
                        <?php $__currentLoopData = $actions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <?php if(in_array(auth()->user()->role ,$action['user_role']) || auth()->user()->hasAnyDirectPermission($action['permission'])): ?>
                                <?php if($action['index'] == true): ?>
                                    <button
                                        type="button"
                                        data-url="<?php echo e($action['url']); ?>"
                                        data-action="approve"
                                        data-method="<?php echo e($action['method']); ?>"
                                        data-callback="reload-table"
                                        data-table-id="<?php echo e(isset($table_id) ? $table_id : ''); ?>"
                                        data-model-name="<?php echo e(__('cargo::view.selected_missions')); ?>"
                                        data-modal-action="<?php echo e(__('cargo::view.send')); ?>"
                                        data-modal-message="<?php echo e(__('cargo::view.modal_message_sure')); ?>"
                                        data-modal-title="<?php echo e($action['title']); ?>"
                                        data-time-alert="2000"
                                        data-multi-rows="true"
                                        class="btn-single-action btn btn-success me-2 <?php if(!isset($action['js_function_caller'])): ?> action-caller <?php endif; ?>"
                                        <?php if(isset($action['js_function_caller'])): ?> data-modal-id="true" onclick="swal.close()" <?php endif; ?>
                                    >
                                        <?php echo e($action['title']); ?>

                                    </button>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php $__env->stopSection(); ?>
                    <!--end::More actions-->

                    <!--begin::Group actions-->
                    <?php echo $__env->make('cargo::adminLte.pages.missions.columns.checkbox-actions', [
                        'table_id' => $table_id,
                        'actions' => $actions,
                        'permission' => 'delete-missions',
                        'url' => fr_route('shipments.multi-destroy'),
                        'callback' => 'reload-table',
                        'model_name' => __('cargo::view.selected_shipments')
                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!--end::Group actions-->
                <?php endif; ?>

            </div>
            <!--end::Card toolbar-->
        </div>
        <!--end::Card header-->


        <!--begin::Card body-->
        <div class="card-body pt-6">

            <!--begin::Table-->
            <?php echo e($dataTable->table()); ?>

            <!--end::Table-->


        </div>
        <!--end::Card body-->
    </div>
    <!--end::Card-->

    <form id="tableForm">
        <?php echo csrf_field(); ?>
        <!-- Mission Modal -->
        <div id="assign-to-captain-modal" class="modal fade">
            <div class="modal-dialog">
                <div class="modal-content">
                <?php if(isset($status)): ?>
                    <input type="hidden" name="checked_ids" class="form-control checked_ids" />
                    <?php if( $status == Modules\Cargo\Entities\Mission::REQUESTED_STATUS): ?>
                        <div class="modal-header">
                            <h4 class="modal-title h6"><?php echo e(__('cargo::view.assign_to_driver')); ?></h4>
                        </div>
                        <div class="modal-body">
                            <div class="row">

                                <?php if($user_role !=  $auth_branch): ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label style="display: block;"><?php echo e(__('cargo::view.table.branch')); ?>:</label>
                                            <select id="change-branch" class="form-control mb-4 kt-select2">
                                                <option></option>
                                                <?php $__currentLoopData = Modules\Cargo\Entities\Branch::where('is_archived', 0)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label style="display: block;"><?php echo e(__('cargo::view.driver')); ?>:</label>
                                            <select name="Mission[captain_id]" class="form-control mb-4 captain_id kt-select2">
                                                <option></option>
                                            </select>
                                        </div>
                                    </div>

                                <?php endif; ?>

                                <?php if($user_role == $auth_branch): ?>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label style="display: block;"><?php echo e(__('cargo::view.driver')); ?>:</label>

                                            <select name="Mission[captain_id]" class="form-control mb-4 captain_id kt-select2">
                                                <?php $__currentLoopData = Modules\Cargo\Entities\Driver::where('is_archived', 0)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $captain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($captain->id); ?>"><?php echo e($captain->name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label><?php echo e(__('cargo::view.due_date')); ?>:</label>
                                        <input type="text" id="kt_datepicker_3" autocomplete="off" class="form-control mb-4"  name="Mission[due_date]" value="<?php echo e(date('Y-m-d')); ?>"/>
                                    </div>
                                </div>

                            </div>

                        </div>
                    <?php endif; ?>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('cargo::view.close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('cargo::view.send')); ?></button>
                    </div>
                <?php endif; ?>
                </div>
            </div>
        </div><!-- /.modal -->
    </form>

    <!-- Ajaxed Models -->
    <div id="ajaxed-model" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">



            </div>
        </div>
    </div><!-- /.modal -->

<?php $__env->stopSection(); ?>


<?php $__env->startSection('toolbar-btn'); ?>
    <!--begin::Button-->
    
    <!--end::Button-->
<?php $__env->stopSection(); ?>



<?php $__env->startSection('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.css')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/signature_pad/1.5.3/signature_pad.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/signature_pad@2.3.2/dist/signature_pad.min.js"></script>
    <script src="<?php echo e(asset('assets/lte/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>
    <?php echo e($dataTable->scripts()); ?>


    <script>
        $('#change-branch').change(function() {

            var id = $(this).val();
            $.get("<?php echo e(route('get-drivers-ajax')); ?>?branch_id=" + id, function(data) {
                $('select[name ="Mission[captain_id]"]').empty();
                $('select[name ="Mission[captain_id]"]').append('<option value=""></option>');
                for (let index = 0; index < data.length; index++) {
                    const element = data[index];

                    $('select[name ="Mission[captain_id]"]').append('<option value="' + element['id'] + '">' + element['name'] + '</option>');
                }
            });
            $('.captain_id').select2({
                placeholder: "<?php echo e(__('cargo::view.select_driver')); ?>",
            })
        });
        $('#change-branch').select2({
            placeholder: "<?php echo e(__('cargo::view.select_branch')); ?>",
        });
        $('.captain_id').select2({
            placeholder: "<?php echo e(__('cargo::view.please_select_branch_first')); ?>",
        })
        function openAjexedModel(element,event)
        {
            event.preventDefault();
            show_ajax_loder_in_button(element);
            $.ajax({
                url: $(element).data('url'),
                type: 'get',
                success: function(response){
                // Add response in Modal body
                $('#ajaxed-model .modal-content').html(response);
                // Display Modal
                $('#ajaxed-model').modal('toggle');
                }
            });
        }
        function show_ajax_loder_in_button(element){
            $(element).bind('ajaxStart', function(){
                $(this).addClass('spinner spinner-darker-success spinner-left mr-3');
                $(this).attr('disabled','disabled');
            }).bind('ajaxStop', function(){
                $(this).removeClass('spinner spinner-darker-success spinner-left mr-3');
                $(this).removeAttr('disabled');
            });
        }

        var inputDate = $(`#kt_datepicker_3`);

        // Trigger date picker for Shipping Date
        inputDate.daterangepicker({
            showDropdowns: true,
            singleDatePicker: true,
            autoUpdateInput: false,
            autoclose: true,
            minYear: parseInt(moment().format('YYYY')) - 10,
            maxYear: parseInt(moment().format('YYYY')) + 10,
            todayHighlight: true,
            startDate: new Date(),
            todayBtn: true,
            locale: {
                format: "DD/MM/YYYY",
                cancelLabel: "<?php echo e(__('view.cancel')); ?>",
                applyLabel: "<?php echo e(__('view.apply')); ?>",
                "fromLabel": "<?php echo e(__('view.from')); ?>",
                "toLabel": "<?php echo e(__('view.to')); ?>",
                "customRangeLabel": "<?php echo e(__('datepicker.custom_range')); ?>",
                "weekLabel": "<?php echo e(__('datepicker.week_label')); ?>",
                "daysOfWeek": [
                    "<?php echo e(__('datepicker.days_of_week.sunday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.monday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.tuesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.wednesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.thursday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.friday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.saturday')); ?>",
                ],
                "monthNames": [
                    "<?php echo e(__('datepicker.month_names.january')); ?>",
                    "<?php echo e(__('datepicker.month_names.february')); ?>",
                    "<?php echo e(__('datepicker.month_names.march')); ?>",
                    "<?php echo e(__('datepicker.month_names.april')); ?>",
                    "<?php echo e(__('datepicker.month_names.may')); ?>",
                    "<?php echo e(__('datepicker.month_names.june')); ?>",
                    "<?php echo e(__('datepicker.month_names.july')); ?>",
                    "<?php echo e(__('datepicker.month_names.august')); ?>",
                    "<?php echo e(__('datepicker.month_names.september')); ?>",
                    "<?php echo e(__('datepicker.month_names.october')); ?>",
                    "<?php echo e(__('datepicker.month_names.november')); ?>",
                    "<?php echo e(__('datepicker.month_names.december')); ?>",
                ],
            }
        }, cb);

        // call back after choose date
        function cb(start) {
            var apiDate = start ? start.format("YYYY-MM-DD H:m") : '';
            var inputShowDate = start ? (start.format("YYYY-MM-DD")) : '';
            if (start) {
                inputDate.val(inputShowDate);
            }
        }

        $('body').on('click', '.btn-single-action', function (e) {
            var _self$data;

            e.preventDefault();
            var self = $(this),
                url = self.data('url'),
                method = self.data('method'),
                action = self.data('action'),
                callback = self.data('callback'),
                modelName = self.data('model-name'),
                modalMessage = self.data('modal-message'),
                modalAction = self.data('modal-action'),
                modalTitle = self.data('modal-title'),
                modalId = self.data('modal-id'),
                tableId = self.data('table-id'),
                requestDataParent = $("#".concat(tableId, "_selected_component")).attr('data-request-data'),
                requestDataSelf = self.attr('data-request-data'),
                multiRows = self.data('multi-rows'),
                timeAlert = (_self$data = self.data('time-alert')) !== null && _self$data !== void 0 ? _self$data : _timerAlert,
                idsSelected = [];

            if(modalId){
                swal.close();

                // get all Data selected
                checkBoxSeleced.each(function(e, ele) {
                    var id = $(ele).data('row-id')
                    idsSelected.push(id)
                })

                console.log(idsSelected);
                $('#tableForm').attr('action', url);
                $('#tableForm').attr('method', method);
                $('.checked_ids').val(JSON.stringify(idsSelected))
                $('#assign-to-captain-modal').modal('toggle');
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedes/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/missions/index.blade.php ENDPATH**/ ?>