<?php
    $user_role = auth()->user()->role;
    $admin  = 1;
    $branch = 3;

    $userBranch = Modules\Cargo\Entities\Branch::where('user_id',auth()->user()->id)->first();
?>



<?php $__env->startSection('pageTitle'); ?>
    <?php echo e(__('cargo::view.manifest')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="card card-custom gutter-b">
    <div class="card-header flex-wrap py-3">
        <div class="card-title">
            <h3 class="card-label">
                <?php echo e(__('cargo::view.manifest')); ?>

            </h3>
        </div>
       
    </div>

    <div class="card-body">
    <form action="<?php echo e(route('missions.get.manifest')); ?>" id="kt_form_1" method="POST">
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group mb-5">
                    <?php
                        if($user_role == $branch){
                            $manifest_captains = Modules\Cargo\Entities\Driver::where('branch_id',$userBranch->id)->get();
                        }else{
                            $manifest_captains = Modules\Cargo\Entities\Driver::all();
                        }
                    ?>
                    
                    <label><?php echo e(__('cargo::view.driver')); ?>:</label>
                    <select 
                        class="form-control  select-branch  <?php $__errorArgs = ['captain_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        data-control="select2"
                        data-placeholder="<?php echo e(__('cargo::view.table.choose_driver')); ?>"
                        data-allow-clear="true"
                        name="captain_id"
                    >
                        <?php $__currentLoopData = $manifest_captains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $captain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($captain->id); ?>"
                            <?php echo e(old('captain_id') == $captain->id ? 'selected' : ''); ?>

                        ><?php echo e($captain->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <?php $__errorArgs = ['captain_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <label><?php echo e(__('cargo::view.manifest_date')); ?>:</label>
                <div class="form-group mb-5">
                    <input type="text" placeholder="<?php echo e(__('cargo::view.manifest_date')); ?>" name="manifest_date" autocomplete="off" value="<?php echo e(old('Shipment.shipping_date')); ?>" class="form-control <?php $__errorArgs = ['manifest_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="kt_datepicker_3" />
                    <?php $__errorArgs = ['manifest_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> 
                        <div class="invalid-feedback">
                            <?php echo e($message); ?>

                        </div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-4">
                <div class="form-group mb-5">
                  <button type="submit" class="btn btn-primary" style="display:block"><?php echo e(__('cargo::view.get_ganifest')); ?></button>
                </div>
            </div>
        </div>
    </form>
    </div>
</div>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('styles'); ?>
    <style media="print">
        
    </style>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('scripts'); ?>
    <script>
        var inputDate = $(`#kt_datepicker_3`);

        // Trigger date picker for Shipping Date
        inputDate.daterangepicker({
            showDropdowns: true,
            singleDatePicker: true,
            autoUpdateInput: false,
            autoclose: true,
            minYear: parseInt(moment().format('YYYY')) - 10,
            maxYear: parseInt(moment().format('YYYY')) + 10,
            todayHighlight: true,
            startDate: new Date(),
            todayBtn: true,
            locale: {
                format: "DD/MM/YYYY",
                cancelLabel: "<?php echo e(__('view.cancel')); ?>",
                applyLabel: "<?php echo e(__('view.apply')); ?>",
                "fromLabel": "<?php echo e(__('view.from')); ?>",
                "toLabel": "<?php echo e(__('view.to')); ?>",
                "customRangeLabel": "<?php echo e(__('datepicker.custom_range')); ?>",
                "weekLabel": "<?php echo e(__('datepicker.week_label')); ?>",
                "daysOfWeek": [
                    "<?php echo e(__('datepicker.days_of_week.sunday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.monday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.tuesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.wednesday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.thursday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.friday')); ?>",
                    "<?php echo e(__('datepicker.days_of_week.saturday')); ?>",
                ],
                "monthNames": [
                    "<?php echo e(__('datepicker.month_names.january')); ?>",
                    "<?php echo e(__('datepicker.month_names.february')); ?>",
                    "<?php echo e(__('datepicker.month_names.march')); ?>",
                    "<?php echo e(__('datepicker.month_names.april')); ?>",
                    "<?php echo e(__('datepicker.month_names.may')); ?>",
                    "<?php echo e(__('datepicker.month_names.june')); ?>",
                    "<?php echo e(__('datepicker.month_names.july')); ?>",
                    "<?php echo e(__('datepicker.month_names.august')); ?>",
                    "<?php echo e(__('datepicker.month_names.september')); ?>",
                    "<?php echo e(__('datepicker.month_names.october')); ?>",
                    "<?php echo e(__('datepicker.month_names.november')); ?>",
                    "<?php echo e(__('datepicker.month_names.december')); ?>",
                ],
            }
        }, cb);

        // call back after choose date
        function cb(start) {
            var apiDate = start ? start.format("YYYY-MM-DD H:m") : '';
            var inputShowDate = start ? (start.format("YYYY-MM-DD")) : '';
            if (start) {
                inputDate.val(inputShowDate);
            }
        }
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('cargo::adminLte.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesignbd/courier.elitedesign.com.bd/Modules/Cargo/Resources/views/adminLte/pages/missions/manifests.blade.php ENDPATH**/ ?>